; /---   FILE TYPE = E
; /---   BLOCK      FDCROM     00 000   80/12/22  15.58
;         IDENT     FDCROM
;  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
;
;                'FLOPPY 'DISK 'CONTROLLER 'R'O'M
;                  'PROCESSOR....'M'O'S'T'E'K 'Z80
;
;         COPYRIGHT CONTROL DATA CORPORATION 1980
;                FOR INTERNAL USE ONLY
;
;*
;
;         VERSION 01
;         ROM 0 PART NUMBER....
;         ROM 1 PART NUMBER....
;         ERS NUMBER....
;         THIS PROGRAM IS RESIDENT IN THE CDC FLEXIBLE
;         DISK CONTROLLER ROMS AND CONTAINS THE DISK
;         CONTROLLER DIAGNOSTICS AND A LOADER TO READ THE
;         CONTROLLER RAM RESIDENT FROM THE DISK.
;
;  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
;         EJECT     EQUATE TABLES
;
;        'E'Q'U'A'T'E 'T'A'B'L'E
;
FDCMD    EQU       10H         ;SELECT CONTROLLER COMMAND
FDSTATUS EQU       10H        ;SELECT CONTROLLER STATUS
FDTRACK  EQU       11H        ;SELECT TRACK
FDSECTOR EQU       12H        ;SELECT SECTOR
FDDATA   EQU       13H        ;SELECT DATA
SWITCHX   EQU       30H        ;READ SWITCHES
LED      EQU       31H         ;LED CONTROL,DRIVE,HEAD,1791 TEST,DENSITY
DSTAT    EQU       32H         ;DISK STATUS AND MASTER RESET (INPUT)
WRESET   EQU       33H       ;WRITE FAULT RESET
IOVECT   EQU       34H       ;ROM, DMA 'F'F, TEST LOOP, INT. OUT
IOIN     EQU       35H       ;I/O  COMMAND/DATA OUTPUT
IOSTATUS EQU       36H       ;I/O STATUS
IOOUT    EQU       37H       ;I/O DATA
CTC0     EQU       50H
CTC1     EQU       51H
CTC2     EQU       52H
CTC3     EQU       53H
DMA0CUR  EQU       80H       ;CH 0, CURRENT ADDR
DMA0WC   EQU       81H       ;CH 0, WORD COUNT
DMA1CUR  EQU       82H
DMA1WC   EQU       83H
DMA2CUR  EQU       84H
DMA2WC   EQU       85H
DMA3CUR  EQU       86H
DMA3WC   EQU       87H
DMASTAT  EQU       88H       ;READ DMA STATUS
DMACMD   EQU       88H       ;WRITE DMA COMMAND
DMAREQ   EQU       89H       ;WRITE REQUEST REGISTER
DMASMSK  EQU       8AH       ;WRITE SINGLE MASK BIT
DMAMODE  EQU       8BH       ;WRITE MODE REGISTER
DMAFFC   EQU       8CH       ;CLEAR BIT FLIP-FLOP
DMATEMP  EQU       8DH       ;READ TEMP REGISTER
DMAMC    EQU       8DH       ;MASTER CLEAR
DMAAMSK  EQU       8FH       ;WRITE ALL MASK BITS
IGDATA   EQU       0D8H      ;SELECT INTERRUPT GENERATOR DATA
IGCMD    EQU       0D9H      ;SELECT INTERRUPT GENERATOR COMMAND
;
ZSTACK   EQU       0
;
;        'UNIVERSAL
LOADFLG  EQU       1      ;CC = LOADED  XX = UNLOADED
LDATT    EQU       2      ;NUMBER OF LOAD ATTEMPTS
;
;        'USED DURING 'D'I'A'G TESTS
MEMNUM   EQU       3
MEMORY   EQU       4          ;MEMORY AVAILABLE      BIT 3 - C000 TO FFFF
;                                                   BIT 2 - 8000 TO BFFF
;                                                   BIT 1 - 4000 TO 7FFF
;                                                   BIT 0 - 0000 TO 3FFF
BANK     EQU       8
BITX      EQU       9
TNUMB    EQU       0AH
;
;        'USED DURING 'L'O'A'D
DISK     EQU       3      ;DISK,SIDE, DENSITY, 'L'E'DS
LDADD    EQU       4      ;WHERE LOAD, WHERE START OPSYS
DATASEL  EQU       6      ;WHERE PUT INPUTED DATA
;
;
;
;        'USED DURING 'P'L'O'A'D
NBYTEIN  EQU       8      ;NUMBER BYTES INPUTED
PDATA    EQU       9      ;DATA (ADDRESS, LENGTH)
;
;        'USED DURING 'D'L'O'A'D
RDATT    EQU       8      ;NUMBER OR READ ATTEMPTS LEFT
NTRACKS  EQU       9
ADTRKLD  EQU       0AH      ;ADDITIONAL TRACK LOAD ADDRESS
DENSITY  EQU       0CH
;
;
;  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
;
;        'PUSH 'BUTTON    <1  'CONTROLLER 'RESET
;                       >3 'DIAGNOSTICS/'AUTOLOAD
;
;
;                  'O'P'E'R'A'T'I'O'N        'D'I'A'G'N'O'S'T'I'C'S
;        'LIGHT 1 -                   'BIT 1
;
;        'LIGHT 2 -                   'BIT 2     'TEST 'NUMBER XXX
;
;        'LIGHT 3 -                   'BIT 3
;
;        LIGHT 4 -                    'ERROR
;
;  *  *  *  *  *  *  *  *  *  *   *  *  *  *  *   *  *  *
;
;'OPERATION 'SWITCHES
;         'BIT 0  -
;         'BIT 1  -  'DETAILED 'INFORMATION ON 'MEMORY FAILURE
;                      0='N'O   1='Y'E'S
;         'BIT 2  -  'IF DETAILED INFO  0='B'A'N'K  1='B'I'T
;         'BIT 3  -  'DIAGNOSTIC 'TEST 7   0='D'O  1='S'K'I'P
;         'BIT 4 AND 5   -    'MEMORY IN 'FLOPPY 'DISK 'SYSTEM
;                   00   'BANK  1
;                   01   'BANK 1,2
;                   10   'BANK 1,2,3
;                   11   'BANK 0,1,2,3
;         'BIT 6  -  'LOOP ON DIAGNOSTICS  0='N'O  1='Y'E'S
;         'BIT 7  -  'DIAGNOSTICS   0='D'O   1='S'K'I'P
;
;'LOAD 'INDICATORS
;         'BIT 0,1,2,3   'TURN ON 'L'E'D LIGHTS (0='O'N  1='O'F'F)
;         'BIT 4  -  'SELECT 'DRIVE  0='DRIVE 2     1='DRIVE 1
;         'BIT 5  -  'SELECT 'HEAD   0='HEAD 0      1='HEAD 1
;         'BIT 6  -  'SELECT 1791 'TESTMODE  0=TEST  1='NORMAL
;         'BIT 7  -  'SELECT 'DENSITY  0='DOUBLE  1='SINGLE
;
;'DISK 'STATUS
;         'BIT 0  -  'NUMBER OF SIDE ON DISK  0='DOUBLE   1='SINGLE
;         'BIT 1  -  'DRIVE 1 READY  0='NO    1='Y'E'S
;         'BIT 2  -  'DRIVE 2 READY  0='NO    1='Y'E'S
;         'BIT 3  -  1791 DATA AVAILABLE   0='N'O    1='Y'E'S
;         'BIT 4  -  'I/'O DATA EXCHANGED    0='N'O    1='Y'E'S
;         'BIT 5  -
;         'BIT 6  -
;         'BIT 7  -  'MANUAL 'RESET DEPRESSED   0='N'O   1='Y'E'S
;
;'LOAD 'I/'O 'VECTOR
;         'BIT 0  -  'SELECT  0='R'O'M  1='R'A'M
;         'BIT 1  -  'ENABLE BLOCK TRANSFERS  0='N'O  1='Y'E'S
;         'BIT 2  -  'ENABLE TEST LOOP  0='ENABLE   1='DISABLE
;         'BIT 3  -  'OUTPUT TEST LOOP DATA   0='Y'E'S   1='N'O
;         'BIT 4  -  'INPUT TEST LOOP DATA   0='Y'E'S    1='N'O
;         'BIT 5  -  'OUTPUT 'INTERRUPT TO 'TERMINAL  0='N'O  1='Y'E'S
;         'BIT 6  -  'TEST LOOP STATUS OUTPUT   0='DISABLE  1='ENDABLE
;         'BIT 7  -
;
;  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
;         EJECT     BEGIN
;
         ORG       0000H
BEGIN    DI                   ;DISABLE INTERRUPTS
         IM        2
         LD        A,07
         LD        I,A
         IN        A,(SWITCHX)
         RRCA
         RRCA
         RRCA
         AND       6
         LD        DE,MEMTAB
         ADD       A,E
         LD        E,A
         LD        A,(DE)
         LD        L,A
         INC       DE
         LD        A,(DE)
         LD        H,A
         LD        SP,HL  ;SET STACK POINTER
         PUSH      HL
         POP       IY

         LD        A,0
         LD        (IY+LDATT),A  ;ZERO OUT DISK LOAD ATTEMPTS
         CPL
         OUT       (IOSTATUS),A
         OUT       (WRESET),A      ;CLEAR ANY WRITE FAULTS
         IN        A,(FDSTATUS)      ;CLEAR ANY FD INT.
         LD        A,1CH
         OUT       (IOVECT),A ;CLEAR I/O, ROM
         OUT       (DMAMC),A  ;MASTER CLEAR DMA
         LD        A,04       ;SHUT OFF 'D'M'A
         OUT       (DMACMD),A
         LD        A,0F0H
         OUT       (LED),A    ;TURN ON LIGHTS
         LD        D,28H
WLOOPA   LD        HL,2000H
WLOOP    DEC       HL
         LD        A,H
         OR        L
         JR        NZ,WLOOP   ;CHECK IF MASTER RESET
         DEC       D
         JR        NZ,WLOOPA
         IN        A,(DSTAT)        ;>3 SECONDS
         BIT       7,A
         JR        NZ,DIAG    ;GO TO DIAGNOSTICS /AUTOLOAD
         LD        A,(IY+LOADFLG)
         XOR       0CCH       ;CHECKING IF PREVIOUS GOOD LOAD
         JP        NZ,DIAG
;
INITIAL            ;INITIALIZE 'F'D'C
         CALL      INITIG     ;INITIALIZE INTERRUPT GENERATOR
         LD        A,0
         OUT       (CTC0),A   ;OUTPUT BASE CTC INT. VECTOR
         CALL      SCTC       ;SETUP HEAD TIMING
         LD        L,(IY+LDADD)
         INC       IY
         LD        H,(IY+LDADD)
         DEC       IY
         JP        (HL)
;         EJECT     DIAGNOSTICS
;
;        'DIAGNOSTICS CONSIST OF';
;
;        'SECTION 0 - 'R'O'M 'CHECKSUM
;        'SECTION 1 - 'FILLING MEMORY WITH 55H AND VERIFYING
;                  - FILLING MEMORY WITH AA'H AND VERIFING
;                  - FILLING MEMORY WITH FF'H AND VERIFING
;                  - FILLING MEMORY WITH 00H AND VERIFING
;        'SECTION 2 -  'W/'R TO 'I'N'T. 'GEN. REGISTERS
;        'SECTION 3 - WRITING/READING TO 1791 CONTROLLER REGISTERS
;        'SECTION 4 - USING DMA TO DO FDDATA TO MEMORY MOVE
;        'SECTION 5 - 'TEST 'I/'O LOOPBACK
;        'SECTION 6 - TEST CTC INTERUPT
;        'SECTION 7 - 'DISK 'DRIVE 'W/'R/'W 'TEST  (TRACK 0 SECTOR 2)
;
;        'UPON EXITING DIAGNOSTICS 00'H IS WRITTEN THROUGH MEMORY.
;
DIAG     
         IN        A,(SWITCHX)
         BIT       7,A
         JP        NZ,LOAD   ;SKIP DIAGNOSTICS
DIAG0    LD        A,0FFH     ;TURN OFF LIGHT
         OUT       (LED),A
         LD        (IY+TNUMB),A ;SAVE TEST NUMBER
         EXX
         LD        B,A
         EXX
         LD        BC,0FFFH
         LD        DE,000H
         LD        L,E
DIAG0A   LD        A,(DE)
         INC       DE
         DEC       BC
         XOR       L          ;CALCULATE ROM CHECKSUM
         RLCA
         LD        L,A
         LD        A,B
         OR        C
         JR        NZ,DIAG0A
         LD        A,L
         LD        (00H),A  ;TEMP TO SEE CALC CHECKSUM
         LD        A,(CHECKSUM)
         XOR       L
         JP        NZ,MDIAGER   ;TEMPORARY TO TEST REST OF ROM
;
DIAG1    
         LD        A,0FEH
         OUT       (LED),A
         LD        (IY+TNUMB),A ;SAVE TEST NUMBER
         EXX
         LD        B,A
         IN        A,(SWITCHX)
         AND       30H
         LD        (IY+MEMORY),A
         LD        E,A
         EXX
;
         LD        A,55H
         LD        IX,DIAG1A
         JP        DWR1       ;FILL 'R'A'M MEMORY WITH 55H
DIAG1A   
         LD        C,55H
         LD        IX,DIAG1B
         JP        DREAD      ;CHECK 'R'A'M MEMORY FOR 55H
DIAG1B   
         LD        A,0AAH
         LD        IX,DIAG1C
         JP        DWR1       ;LOAD 'R'A'M MEMORY WITH AAH
DIAG1C   
         LD        C,0AAH
         LD        IX,DIAG1D
         JP        DREAD
DIAG1D   
         LD        A,0FFH
         LD        IX,DIAG1E
         JP        DWR1       ;FILL 'R'A'M MEMORY WITH FFH
DIAG1E   
         LD        C,0FFH
         LD        IX,DIAG1F
         JP        DREAD      ;CHECK 'R'A'M MEMORY FOR 0FFH
DIAG1F   
         LD        A,0
         LD        IX,DIAG1G
         JP        DWR1       ;LOAD 'R'A'M MEMORY WITH 0
DIAG1G   
         LD        C,0
         LD        IX,DIAG2
         JP        DREAD
;
DIAG2              ;'TEST 'INT. GENERATOR
         LD        A,0FDH
         OUT       (LED),A    ;TURN ON DIAG 2 LIGHT
         LD        (IY+TNUMB),A ;SAVE TEST NUMBER
         LD        C,0FH
         LD        A,C
         OUT       (IGCMD),A      ;RESET 9519
         LD        A,0A6H
         OUT       (IGCMD),A  ;PRESELECT READ IMR
         LD        A,0B0H
         OUT       (IGCMD),A  ;PRESELECT WRITE IMR
DIAG2A   LD        A,C
         OUT       (IGDATA),A ;OUTPUT TO IMR
         IN        A,(IGDATA) ;INPUT FROM IMR
         XOR       C
         JP        NZ,DIAGERR ;CHECK IF GOOD
         DEC       C
         JR        NZ,DIAG2A ;CHECK IF DONE
         LD        C,0FH
         LD        A,C
         OUT       (IGCMD),A      ;RESET 9519
         LD        A,0AEH     ;PRESELECT READ ACR
         OUT       (IGCMD),A
         LD        A,0C0H
         OUT       (IGCMD),A  ;PRESELECT WRITE ACR
DIAG2B   LD        A,C
         OUT       (IGDATA),A ;OUTPUT TO IMR
         IN        A,(IGDATA) ;INPUT FROM IMR
         XOR       C
         JP        NZ,DIAGERR ;CHECK IF GOOD
         DEC       C
         JR        NZ,DIAG2B ;CHECK IF DONE
;
         CALL      LEDWAIT
;
DIAG3              ;WRITE/READ 1791 CONTROLLER REGISTERS
         LD        A,0FCH
         OUT       (LED),A    ;TURN ON DIAG 3 LIGHT
         LD        (IY+TNUMB),A ;SAVE TEST NUMBER
         LD        A,55H
         OUT       (FDTRACK),A    ;CONTROLLER TRACK REGISTER
         CALL      DWAIT
         IN        A,(FDTRACK)
         XOR       55H
         JP        NZ,DIAGERR
         LD        A,0AAH
         OUT       (FDTRACK),A
         CALL      DWAIT
         IN        A,(FDTRACK)
         XOR       0AAH
         JP        NZ,DIAGERR
         LD        A,55H
         OUT       (FDSECTOR),A    ;SECTOR REGISTER
         CALL      DWAIT
         IN        A,(FDSECTOR)
         XOR       55H
         JP        NZ,DIAGERR
         LD        A,0AAH
         OUT       (FDSECTOR),A
         CALL      DWAIT
         IN        A,(FDSECTOR)
         XOR       0AAH
         JP        NZ,DIAGERR
         LD        A,55H
         OUT       (FDDATA),A    ;DATA REGISTER
         CALL      DWAIT
         IN        A,(FDDATA)
         XOR       55H
         JP        NZ,DIAGERR
         LD        A,0AAH
         OUT       (FDDATA),A
         CALL      DWAIT
         IN        A,(FDDATA)
         XOR       0AAH
         JP        NZ,DIAGERR
         CALL      LEDWAIT
;
DIAG4    
         LD        A,0FBH
         OUT       (LED),A    ;TURN ON DIAG 4 LIGHT
         LD        (IY+TNUMB),A ;SAVE TEST NUMBER
         CALL      DMASUB
         CALL      DMASUB2
         LD        HL,6300H
         LD        DE,100H
DIAG4E   
         LD        A,(HL)    ;CHECK IF MOVED CORRECTLY
         XOR       L
         JP        NZ,DIAGERR
         INC       HL
         DEC       DE
         LD        A,D
         OR        E
         JR        NZ,DIAG4E
         JP        DIAG5
;
;
DMASUB   LD        DE,200H
         LD        HL,6000H
DMASUBA  LD        A,L
         LD        (HL),A
         INC       HL
         DEC       DE
         LD        A,D
         OR        E
         JR        NZ,DMASUBA
         LD        DE,200H
         LD        HL,6300H
DMASUBB  LD        A,55H
         LD        (HL),A
         INC       HL
         DEC       DE
         LD        A,D
         OR        E
         JR        NZ,DMASUBB
         RET
;
DMASUB2  DI
         LD        A,0C7H
         OUT       (DMACMD),A ;DISABLE DMA INT
         LD        A,5BH
         LD        HL,FDDATA
         LD        DE,00
         CALL      SDMA
         LD        A,55H
         LD        HL,6300H
         LD        DE,100H
         CALL      SDMA

         LD        BC,100H
         LD        HL,6000H
DMASUBC  LD        A,L
         OUT       (FDDATA),A
         INC       HL
         LD        A,7
         OUT       (DMAREQ),A ;SET DMA REQ
         LD        A,03      ;CLEAR CH 3 INT BIT
         OUT       (DMAREQ),A
         DEC       BC
         LD        A,B
         OR        C
         JR        NZ,DMASUBC
         RET
;
;
DIAG5    
         LD        A,0FAH     ;'I/'O LOOP TEST
         OUT       (LED),A    ;TURN ON DIAG TEST 5 LIGHTS
         LD        (IY+TNUMB),A ;SAVE TEST NUMBER
         LD        A,18H
         OUT       (IOVECT),A    ;TEST ENABLE
         LD        A,55H
         OUT       (IOOUT),A  ;OUTPUT DATA
         LD        A,10H
         OUT       (IOVECT),A    ;TEST OUT
         LD        A,08H
         OUT       (IOVECT),A    ;TEST IN
         IN        A,(IOIN) ;INPUT TEST DATA
         XOR       55H
         JP        NZ,DIAGERR
         LD        A,0AAH
         OUT       (IOOUT),A  ;OUTPUT DATA
         LD        A,10H
         OUT       (IOVECT),A    ;TEST OUT
         LD        A,08H
         OUT       (IOVECT),A    ;TEST IN
         IN        A,(IOIN) ;INPUT TEST DATA
         XOR       0AAH
         JP        NZ,DIAGERR
         LD        A,18H
         OUT       (IOVECT),A
         LD        A,55H
         OUT       (IOSTATUS),A
         LD        A,58H      ;ENABLE STATUS LOOPBACK, TEST OUT
         OUT       (IOVECT),A
         LD        A,48H        ;TEST IN
         OUT       (IOVECT),A
         IN        A,(IOIN)
         XOR       55H
         JP        NZ,DIAGERR
         LD        A,0AAH
         OUT       (IOSTATUS),A
         LD        A,58H
         OUT       (IOVECT),A
         LD        A,48H      ;TEST IN
         OUT       (IOVECT),A
         IN        A,(IOIN)
         XOR       0AAH
         JP        NZ,DIAGERR
         LD        A,1CH
         OUT       (IOVECT),A
;
DIAG6              ;'C'T'C 'TEST
         LD        A,0F9H
         OUT       (LED),A    ;TURN DIAG TEST 6 LIGHT ON
         LD        (IY+TNUMB),A ;SAVE TEST NUMBER
         CALL      INITIG
         LD        HL,8000H
         LD        A,00H
         OUT       (CTC0),A   ;INT VECTOR
         LD        A,85H  ;EI,TIMER,#16,NEG TRIG,TIME CONSTANT
         OUT       (CTC0),A   ;CONTROL CODE
         LD        A,080H
         OUT       (CTC0),A   ;INITIAL COUNT AND START
         LD        DE,0
         EI
DLOOP6   
         IN        A,(CTC0)
         DEC       HL
         LD        A,L
         OR        H
         JP        Z,DIAGERR
         LD        A,E
         AND       A
         JR        Z,DLOOP6   ;WAIT FOR CTC INTERRUPT
         CALL      SCTC
         CALL      LEDWAIT

;
DIAG7              ;'DISK 'DRIVE 'W/'R TEST
         LD        A,0F8H
         OUT       (LED),A    ;TURN DIAG TEST 7 LIGHT ON
         LD        (IY+TNUMB),A ;SAVE TEST NUMBER
         IN        A,(SWITCHX)
         BIT       3,A        ;CHECK SKIP TEST 7 SWITCHX
         JP        NZ,DIAG8
         CALL      INITIG
         CALL      SCTC       ;SET UP HEAD LOAD TIMING
         IN        A,(DSTAT)  ;SEE IF DISK ONE IS READY
         BIT       1,A
         JR        Z,DIAG7A
         LD        A,58H     ;DOUBLE DENSITY, UNIT 1, HEAD 0
         JP        DIAG7B
DIAG7A   IN        A,(DSTAT)
         BIT       2,A
         JR        Z,DIAG7
         LD        A,48H     ;DOUBLE DENSITY UNIT 2,HEAD 0
DIAG7B   OUT       (LED),A
         LD        (IY+DISK),A
DIAG7C2  LD        D,06       ;MULTIPLE STEP OUT FOR NEW UNITS
DIAG7C3  
         LD        A,0A7H     ;OUTPUT STEP COMMAND
         CALL      X1791
         JP        NZ,DIAGERR
         DEC       D
         JR        NZ,DIAG7C3
;
         CALL      LEDWAIT
         LD        A,0F7H     ;OUTPUT RESTORE
         CALL      X1791
         JP        NZ,DIAGERR
         CALL      LEDWAIT
         CALL      SCTC
;
         CALL      PTEST
         LD        B,A        ;TEST IF NOT FIND FORMATED DISK
         XOR       03
         JP        Z,DIAGERR
         LD        A,B
         XOR       01         ;TEST IF NOT PLATO
         JP        NZ,DIAG8
         LD        A,(4028H)
         BIT       7,A        ;TEST IF WRITE PERMITTED
         JP        Z,DIAG8
;
         CALL      LEDWAIT
         LD        A,(IY+DISK)
         SET       5,A        ;SELECT SIDE 2
         OUT       (LED),A
         BIT       7,A
         JR        Z,DIAG7C4  ;SELECT LAST SECTOR ON TRACK 76
         LD        A,0E5H
         JR        DIAG7C5
DIAG7C4  LD        A,0F0H
DIAG7C5  OUT       (FDSECTOR),A
         LD        H,76       ;SELECT TRACK 76
         CALL      SEEK
;
         JP        NZ,DIAGERR
;
         CALL      DMASUB    ;SET UP WHAT TO WRITE AREA AND READ AREA
;     SETUP DMA
         LD        A,57H
         LD        HL,FDDATA
         LD        DE,00
         CALL      SDMA
         LD        A,59H
         LD        HL,6001H
         LD        DE,200H
         CALL      SDMA
         LD        A,5
         OUT       (DMAREQ),A ;FORCE REQUEST
;
         LD        A,5FH     ;WRITE SECTOR COMMAND
         CALL      X1791
         JP        NZ,DIAGERR
         IN        A,(FDSTATUS)
         BIT       2,A
         JP        Z,DIAG7C2
;
         LD        A,5BH
         LD        HL,FDDATA
         LD        DE,0
         CALL      SDMA

         LD        A,55H
         LD        HL,6301H
         LD        DE,200H
         CALL      SDMA
;
         LD        A,73H      ;READ SECTOR COMMAND
         CALL      X1791
         JP        NZ,DIAGERR
;   COMPARE  READ SECTOR TO ACTUAL
         LD        HL,6301H

         LD        A,(IY+DISK)
         BIT       7,A        ;VARY LENGTH OF CHECK IF
         JR        Z,DIAG7G1  ;SINGLE OR DOUBLE DENSITY
         LD        DE,7FH
         JR        DIAG7G
DIAG7G1  LD        DE,1FFH
DIAG7G   
         LD        A,(HL)    ;CHECK IF MOVED CORRECTLY
         XOR       L
         JP        NZ,DIAGERR
         INC       HL
         DEC       DE
         LD        A,D
         OR        E
         JR        NZ,DIAG7G
         CALL      DMASUB
;     SETUP DMA      TO WRITE 55H TO TEST SECTOR
         LD        A,57H
         LD        HL,FDDATA
         LD        DE,00
         CALL      SDMA

         LD        A,59H
         LD        HL,6301H
         LD        DE,200H
         CALL      SDMA
         LD        A,5
         OUT       (DMAREQ),A ;FORCE REQUEST
;
         LD        A,5FH     ;WRITE SECTOR COMMAND
         CALL      X1791
         JP        NZ,DIAGERR
;         EJECT
;
;
;        'E'X'I'T 'D'I'A'G'N'O'S'T'I'C'S
;
DIAG8              ;WRITE 00'H THROUGH MEMORY AND EXIT DIAG
         IN        A,(SWITCHX)
         BIT       6,A        ;TEMP TEST TO LOOP ON DIAG
         JP        NZ,DIAG
         LD        A,00
         LD        IX,LOAD
         JP        DWR1
;
DWAIT    LD        B,10H      ;103 MICRO SECONDS
DWAIT1   DEC       B
         JR        NZ,DWAIT1
         RET
;
LEDWAIT  
         LD        HL,1000H
LEDW2    
         CALL      DWAIT
         DEC       HL
         LD        A,L
         OR        H
         JR        NZ,LEDW2
         RET
;
DWR1     
         LD        HL,4000H
         LD        DE,4001H
         LD        BC,3FE0H
         LD        (HL),A
         LDIR
         LD        HL,8000H
         LD        DE,8001H
         LD        BC,3FE0H
         LD        (HL),A
         LDIR
         LD        HL,0C000H
         LD        DE,0C001H
         LD        BC,3FE0H
         LD        (HL),A
         LDIR
         JP        (IX)
;
DREAD    
         EXX
         LD        A,E        ;FIND MEMORY
         EXX
         LD        B,A
         AND       20H
         XOR       20H
         LD        HL,0FFE0H
         LD        DE,0BFE0H
         JR        Z,DREAD1
         LD        HL,0BFE0H
         LD        DE,7FE0H
         LD        A,B
         AND       10H
         XOR       10H
         JR        Z,DREAD1
         LD        HL,07FE0H
         LD        DE,3FE0H
;
DREAD1   
         LD        A,H
         XOR       7FH
         JR        Z,DREAD2
         LD        A,H
         XOR       0BFH
         JR        Z,DREAD2
         LD        A,(HL)
         LD        B,A
         XOR       C
         JR        Z,DREAD2
         LD        C,0
DERR     RRCA
         JR        C,DERR2
         INC       C
         JR        DERR
DERR2    LD        A,C
         CPL
         LD        (IY+BITX),A
         EXX
         LD        C,A
         EXX
         LD        A,H
         RLCA
         RLCA
         AND       03
         CPL
         LD        (IY+BANK),A
         EXX
         LD        D,A
         EXX
         JR        MDIAGER
DREAD2   
         DEC       HL
         DEC       DE
         LD        A,E
         OR        D
         JR        NZ,DREAD1
         EXX
         LD        A,E
         EXX
         XOR       30H        ;CHECK IF BLOCK 0
         JR        NZ,DREAD3
         LD        HL,DREAD00
         LD        DE,5000H
         LD        BC,100H
         LDIR
         JP        5000H
DREAD00  LD        A,1
         OUT       (IOVECT),A
         LD        A,(4020H)
         LD        (0),A
         LD        HL,0
         LD        DE,1
         LD        BC,3FFFH
         LDIR
         LD        A,(4020H)
         LD        C,A
         LD        HL,3FFFH
         LD        DE,3FFEH   ;TEST BLOCK 0
DREAD01  LD        A,(HL)
         LD        B,A
         XOR       C
         JR        Z,DREAD02
         LD        C,0
DERR0    RRCA
         JR        C,DERR02
         INC       C
         JR        DERR0
DERR02   LD        A,C
         CPL
         LD        (IY+BITX),A
         EXX
         LD        C,A
         EXX
         LD        A,H
         RLCA
         RLCA
         AND       03
         CPL
         LD        (IY+BANK),A
         EXX
         LD        D,A
         EXX
         LD        A,0
         OUT       (IOVECT),A
         JP        MDIAGER
DREAD02  DEC       HL
         DEC       DE
         LD        A,E
         OR        D
         JR        NZ,DREAD01
         LD        A,0
         OUT       (IOVECT),A
DREAD3   JP        (IX)
;
MDIAGER  
         EXX                         ;B TEST NUMBER
MDERR2   
         IN        A,(SWITCHX)        ;C BIT
         BIT       1,A               ;D BANK
         JR        NZ,DTEST          ;E MEMORY
         LD        A,B
         AND       0F7H
         OUT       (LED),A
         JR        MDERR2
DTEST    BIT       2,A
         JR        NZ,DTEST2
         LD        A,D
         OUT       (LED),A
         JR        MDERR2
DTEST2   LD        A,C
         OUT       (LED),A
         JR        MDERR2
;
DIAGERR  
         LD        A,(IY+TNUMB)
         AND       0F7H
         OUT       (LED),A
         JR        DIAGERR
;         EJECT     TEST FOR PLATO
;        TEST IF PLATO SYSTEM
;                  EXIT A = 1 PLATO
;                           2 CPM
;                           3 RECORD NOT FOUND
;                           4 NOT PLATO - SINGLE DENSITY
;                           5 NOT PLATO - DOUBLE DENSITY

;                       TRACK 0 READ IN AT 4000H
;
PTEST4   
         LD        A,(IY+DISK)
         BIT       7,A        ;TEST SECOND TIME THROUGH
         JR        NZ,PTEST6
         SET       7,A
         LD        (IY+DISK),A
         OUT       (LED),A
         LD        A,0FEH     ;SELECT SECTOR 1
         JR        PTEST5
;
PTEST6   
         LD        A,03
         LD        (IY+DENSITY),A
         RET
;
;
PTEST    
         LD        A,0FFH     ;SELECT SECTOR 0
PTEST5   
         OUT       (FDSECTOR),A
         LD        A,0E3H
         CALL      X1791
PTEST9   
         JR        NZ,PTEST4 ;TEST FOR RECORD NOT FOUND
         LD        A,5BH
         LD        HL,FDDATA
         LD        DE,0
         CALL      SDMA

         LD        A,55H
         LD        HL,4000H
         LD        DE,3000H
         CALL      SDMA
;
         LD        A,63H      ;READ MULTI- SECTOR COMMAND
         LD        E,0
         OUT       (FDCMD),A
         EI
X1791X   
         LD        A,E
         XOR       01         ;WAIT FOR INTERRUPT
         JR        NZ,X1791X
         DI
PTEST10  
         IN        A,(FDSTATUS)
         BIT       0,A
         JR        Z,PTEST10
;
         LD        A,(4000H)
         XOR       4          ;'D
         JR        NZ,PTEST3
         LD        A,(4001H)
         XOR       5          ;'E
         JR        NZ,PTEST3
         LD        A,(4002H)
         XOR       6          ;'F
         JR        NZ,PTEST3
         LD        A,(4003H)
         XOR       9          ;'I
         JR        NZ,PTEST3
         LD        A,(4004H)
         XOR       0EH        ;'N
         JR        NZ,PTEST3
         LD        A,1
         LD        (IY+DENSITY),A
         RET
;
PTEST3   LD        A,(4002H)
         XOR       43H        ;TEST IF ASCII 'C
         JR        NZ,PTEST8
         LD        A,(4003H)
         XOR       50H        ;TEST IF ASCII 'P
         JR        NZ,PTEST8
         LD        A,2
         LD        (IY+DENSITY),A
         RET
;
PTEST8   LD        A,(IY+DISK)
         BIT       7,A

         JR        Z,PTEST7
         LD        A,4
         LD        (IY+DENSITY),A

         RET
;
PTEST7   LD        A,5
         LD        (IY+DENSITY),A
         RET
;
;         EJECT     SUBROUTINES
;
         ORG       0700H
; 'I'N'T'E'R'R'U'P'T 'J'U'M'P 'T'A'B'L'E
         DEFW      ICTC0
         DEFW      ICTC1
         DEFW      ICTC2
         DEFW      ICTC3
         DEFW      COM1
         DEFW      STAT1
         DEFW      DATAIN
         DEFW      DATAOUT
         DEFW      S1791
         DEFW      IDMA
;
;
;
ICTC0    
IDMA     
         LD        E,02
;
DATAOUT  
;
COM1     
STAT1    
ICTC1    
ICTC2    
ICTC3    
         EI
         RETI
;
;
;
RETURN   
         EXX
         EI
         RETI
;
;
DATAIN   
         EXX
         PUSH      AF
         PUSH      HL
         PUSH      DE
         LD        L,(IY+DATASEL)
         INC       IY
         LD        H,(IY+DATASEL)
         DEC       IY
         LD        A,(IY+NBYTEIN)
         ADD       A,L
         LD        L,A

         IN        A,(IOIN)
         LD        (HL),A
         LD        A,(IY+NBYTEIN)
         INC       A
         LD        (IY+NBYTEIN),A
         POP       DE
         POP       HL
         POP       AF
         JP        RETURN
;
;
;
S1791    
         LD        E,01
         EI
         RETI
;
;        'SUBROUTINE TO EXECUTE 1791
;                  ENTER A= COMMAND
;                  EXIT  Z = 0 OKAY
;                          = 1 TIMEOUT
;
X1791    
         LD        E,0
         LD        HL,0F000H
         OUT       (FDCMD),A
         EI
X1791A   
         DEC       HL
         LD        A,L
         OR        H
         JR        Z,X1791C
         LD        A,E
         XOR       01         ;WAIT FOR INTERRUPT
         JR        NZ,X1791A
         DI
X1791B   IN        A,(FDSTATUS)
         BIT       0,A
         JR        Z,X1791B   ;WAIT TO GO NON-BUSY
         LD        A,0
         AND       A
         RET
X1791C   LD        A,1
         AND       A
         RET
;
;
;        'SUBROUTINE TO SET UP HEAD LOAD TIMING
;
SCTC     LD        A,1FH
         OUT       (CTC0),A   ;SET UP CTC HEAD LOAD TIMER
         LD        A,9CH
         OUT       (CTC0),A
         LD        A,57H
         OUT       (CTC1),A
         LD        A,40H
         OUT       (CTC1),A
         RET
;
;
;        'INITIALIZE 'INTERRUPT 'GENERATOR SUB ROUTINE
;
INITIG   LD        A,00
         OUT       (IGCMD),A ;RESET 9519
         LD        B,10H      ;B= TABLE LENGTH C/D
         LD        HL,TABLEFA    ;HL= FWA OF C/D TABLE
AAA      LD        C,IGCMD   ;C= COMMAND
         OUTI
         LD        C,IGDATA        ;C_DATA
         OUTI
         JR        NZ,AAA     ;DONE'/
         LD        A,0A1H
         OUT       (IGCMD),A    ;ENABLE MASTER INTERRUPT
         RET
;
TABLEFA  
         DB        0C0H,0FFH,0E0H,08H,0E1H,0AH,0E2H,0CH,0E3H,0EH
         DB        0E4H,10H,0E5H,12H,0B0H
TABMASK  DB        0C0H
;
         ORG       7D0H
MEMTAB   DEFW      7FF0H
         DEFW      0BFF0H
         DEFW      0FFF0H
         DEFW      0FFF0H
;
         ORG       7E0H
         DB        0C3H
         DEFW      SCTC
         DB        0C3H
         DEFW      X1791
         DB        0C3H
         DEFW      SDMA
         DB        0C3H
         DEFW      SEEK
         DB        0C3H
         DEFW      LEDWAIT
         DB        0C3H
         DEFW      INITIG
;
;
;         EJECT     AUTOLOAD ROUTINES
         ORG       800H
;        'A'U'T'O'L'O'A'D 'ROUTINES
;
LOAD     
         LD        A,0FEH
         OUT       (LED),A    ;TURN OFF LIGHTS
         CALL      INITIG
         CALL      SCTC

         LD        A,0
         LD        (IY+LDATT),A
         LD        A,0CCH
         OUT       (IOSTATUS),A
LOAD4    LD        A,(IY+LDATT)
         SUB       05
         JP        P,PLOAD
         IN        A,(DSTAT)  ;SEE IF DISK ONE IS READY
         BIT       1,A
         JR        Z,LOAD2
         LD        A,5EH       ;DISK ONE IS READY
         JR        LOAD3
LOAD2    
         BIT       2,A             ;CHECK IF DISK 2 IS READY
         JR        Z,PLOAD
         LD        A,4EH       ;DISK 2 IS READY
LOAD3    LD        (IY+DISK),A
         OUT       (LED),A
         JP        DLOAD
;
PLOAD    
         EI
         PUSH      IY
         POP       HL
         LD        A,PDATA
         ADD       A,L
         LD        L,A
         LD        (IY+DATASEL),L
         INC       IY
         LD        (IY+DATASEL),H
         DEC       IY
         IN        A,(IOIN)
         XOR       04H        ;CHECK FOR LOAD COMMAND
         JP        NZ,LOAD4
         LD        A,33H
         OUT       (IOSTATUS),A
         LD        HL,8000H
PLOAD1   LD        A,L
         OR        H
         JP        Z,LOAD4
         IN        A,(IOIN)
         XOR       0FBH        ;WAIT FOR REPEAT COMMAND (INVERTED)
         JR        NZ,PLOAD1
;
         LD        A,0
         LD        (IY+NBYTEIN),A
         LD        HL,8000H
PLOAD2   DEC       HL
         LD        A,H
         OR        L
         JP        Z,LOAD4
         LD        A,(IY+NBYTEIN)
         XOR       04
         JR        NZ,PLOAD2

;
;        SET UP DMA
;
         LD        A,46H
         LD        L,(IY+PDATA)
         INC       IY
         LD        H,(IY+PDATA)
         INC       IY
         LD        E,(IY+PDATA)
         INC       IY
         LD        D,(IY+PDATA)
         INC       DE
         DEC       IY
         DEC       IY
         DEC       IY
         CALL      SDMA
         LD        A,1EH
         OUT       (IOVECT),A   ;ENABLE DMA 'F'F, IN, ROM
         LD        A,3AH
         OUT       (IGCMD),A     ;DISABLE  DATAIN INT
         LD        A,0DDH
         OUT       (IOSTATUS),A
;
         LD        E,00
         EI
PLOAD3   
         LD        A,E
         XOR       02
         JR        NZ,PLOAD3
         DI
         CALL      INITIG     ;TURN DATAIN INT. BACK ON
;
         LD        L,(IY+PDATA)
         INC       IY
         LD        H,(IY+PDATA)
         DEC       IY
         LD        A,(HL)
         XOR       38H
         JP        NZ,LOAD4
         INC       HL
         LD        A,(HL)
         INC       HL
         LD        (IY+LDADD),L
         INC       IY
         LD        (IY+LDADD),H
         DEC       IY
         XOR       0C7H
         JP        NZ,LOAD4
         LD        E,(IY+PDATA)
         INC       IY
         LD        D,(IY+PDATA)
         INC       IY
         LD        L,(IY+PDATA)
         INC       IY
         LD        H,(IY+PDATA)
         DEC       IY
         DEC       IY
         DEC       IY
         LD        BC,00
PLOAD4   LD        A,(DE)
         XOR       B
         RLCA
         LD        B,A
         LD        A,(DE)
         XOR       C
         RRCA
         LD        C,A
         DEC       HL
         INC       DE
         LD        A,H
         OR        L
         JR        NZ,PLOAD4
         LD        A,(DE)
         XOR       B
         JP        NZ,LOAD4
         INC       DE
         LD        A,(DE)
         XOR       C
         JP        NZ,LOAD4
         LD        A,40H
         OUT       (IOSTATUS),A
         LD        A,0CCH
         LD        (IY+LOADFLG),A    ;STORE GOOD LOAD
         JP        INITIAL
;
;
DLOAD    
         LD        A,(IY+LDATT)  ;TEST IF FIVE TRIES
         LD        B,A
         SUB       5
         JP        P,DDONE
         LD        A,B
         INC       A
         LD        (IY+LDATT),A
         LD        A,(IY+DISK)
         AND       5FH
         LD        (IY+DISK),A   ;RESET TO DOUBLE DENSITY SIDE 1
         OUT       (LED),A
;
;
;
DLOAD3   
         CALL      SCTC
;
         LD        D,06                                 ; <<<<<<<<<<<< TAS (PATCHED FROM EEPROM CONTENTS)
DLOAD3X
         LD        A,0A7H     ;OUTPUT STEP COMMAND
         CALL      X1791
         JP        NZ,DLOAD
         DEC       D                                    ; <<<<<<<<<<<< TAS (PATCHED FROM EEPROM CONTENTS)
         JR        NZ,DLOAD3X                           ; <<<<<<<<<<<< TAS (PATCHED FROM EEPROM CONTENTS)
         CALL      LEDWAIT
;
         LD        A,0F7H     ;RESTORE COMMAND
         CALL      X1791
         JP        NZ,DLOAD
         DI
         CALL      LEDWAIT
         CALL      SCTC
         CALL      PTEST      ;TEST IF THIS IS PLATO SYSTEM (DISK FORMAT)
         LD        B,A
         XOR       02         ;JUMP IF 'C'P'M
         JP        Z,4000H
         LD        A,B
         XOR       01
         JP        NZ,DLOAD
;
;        FIND 'S'I'D'E 'T'R'A'C'K  'E'T'C
DLOAD5   CALL      LEDWAIT
         CALL      SCTC
         LD        A,(IY+DISK)
         LD        B,A
         LD        A,(4080H)  ;SIDE
         RRCA
         RRCA
         RRCA                 ;SELECT SIDE
         OR        B
         LD        (IY+DISK),A
         OUT       (LED),A
         LD        A,(4081H)  ;SELECT TRACK
         LD        H,A
         LD        A,(4082H)  ;SELECT SECTOR
         CPL
         OUT       (FDSECTOR),A
         LD        A,(4083H)  ;NUMBER ADDITIONAL TRACKS
         LD        (IY+NTRACKS),A
;
         CALL      SEEK
         JP        NZ,DLOAD
;
         LD        A,5
         LD        (IY+RDATT),A
RDTRY    
         LD        A,(IY+RDATT)  ;IF 5 READ TRIES, REPOSITION
         DEC       A
         JP        Z,DLOAD
         LD        (IY+RDATT),A
;
;
         LD        A,5BH
         LD        HL,FDDATA
         LD        DE,0
         CALL      SDMA

         LD        A,55H
         LD        HL,(4086H)
         LD        (IY+DATASEL),L
         INC       IY
         LD        (IY+DATASEL),H
         DEC       IY
         LD        DE,5000H
         CALL      SDMA
;
         LD        A,63H      ;READ MULTI SECTOR COMMAND
         LD        E,0
         OUT       (FDCMD),A
         EI
X1791M   
         LD        A,E
         XOR       01         ;WAIT FOR INTERRUPT;
         JR        NZ,X1791M
         DI
X1791N   IN        A,(FDSTATUS)
         BIT       0,A
         JR        Z,X1791N
         IN        A,(FDSTATUS)
         BIT       3,A
         JP        Z,RDTRY
         BIT       2,A
         JP        Z,RDTRY
         LD        L,(IY+DATASEL)
         INC       IY
         LD        H,(IY+DATASEL)
         DEC       IY
         LD        A,(HL)
         XOR       38H        ;CONTROLWARE CODE
         JP        NZ,DLOAD
         INC       HL
         LD        A,(HL)
         INC       HL
         LD        (IY+LDADD),L
         INC       IY
         LD        (IY+LDADD),H
         DEC       IY
         XOR       0C7H
         JP        NZ,DLOAD
;
;        'LOAD ADDITIONAL TRACKS
DLOAD13  OUT       (DMAFFC),A      ;CLEAR BYTE COUNTER
         IN        A,(DMA1CUR)
         LD        L,A             ;INPUT WORD ADDRESS
         IN        A,(DMA1CUR)
         LD        H,A
         LD        (IY+ADTRKLD),L
         INC       IY
         LD        (IY+ADTRKLD),H
         DEC       IY
DLOAD4   LD        A,(IY+NTRACKS)
         AND       A
         JR        Z,DLOAD8
         DEC       A
         LD        (IY+NTRACKS),A
         BIT       0,A
         JR        Z,DLOAD4A  ;CHECK IF SWITCH SIDE
         LD        A,0A6H     ;OUTPUT STEP COMMAND
         CALL      X1791
         JP        NZ,PLOAD
         CALL      LEDWAIT
DLOAD4A  LD        A,(IY+DISK)   ;CHANGE SIDES
         XOR       20H
         LD        (IY+DISK),A
         OUT       (LED),A
         CALL      LEDWAIT
         LD        A,5BH
         LD        HL,FDDATA
         LD        DE,0
         CALL      SDMA

         LD        A,(IY+DISK)
         BIT       7,A
         JR        NZ,DLOAD11
         LD        A,0FFH     ;SELECT SECTOR 0
         OUT       (FDSECTOR),A
         JR        DLOAD12
DLOAD11  LD        A,0FEH
         OUT       (FDSECTOR),A

DLOAD12  LD        A,55H
         LD        L,(IY+ADTRKLD)
         INC       IY
         LD        H,(IY+ADTRKLD)
         DEC       IY
         LD        DE,5000H
         CALL      SDMA
;
         LD        A,63H      ;READ MULTI SECTOR COMMAND
         LD        E,0
         OUT       (FDCMD),A
         EI
X1791H   
         LD        A,E
         XOR       01         ;WAIT FOR INTERRUPT
         JR        NZ,X1791H
         DI
X1791I   IN        A,(FDSTATUS)
         BIT       0,A
         JR        Z,X1791I
         CALL      LEDWAIT

         JR        DLOAD13


DLOAD8   LD        A,0CCH
         LD        (IY+LOADFLG),A  ;GOOD LOAD
         LD        A,40H
         OUT       (IOSTATUS),A
         JP        INITIAL
;
DDONE    LD        A,(IY+DENSITY)
         LD        B,A
         XOR       1
         JR        Z,DDONE4
         LD        A,B
         XOR       5
         JR        NZ,DDONE2
DDONE5   LD        A,22H
         JR        DDONE6
DDONE2   LD        A,B
         XOR       4
         JR        NZ,DDONE3
         LD        A,21H
         JR        DDONE6
DDONE3   LD        A,20H
DDONE6   OUT       (IOSTATUS),A
         JP        LOAD4
;
DDONE4   
         LD        A,(IY+DISK)
         BIT       7,A
         JR        Z,DDONE5
         LD        A,21H
         JR        DDONE6
;
;
;
;        SET UP DMA
;                  A = MODE
;                  HL = CURRENT ADDRESS
;                  DE = WORD COUNT
;
SDMA     
         OUT       (DMAFFC),A     ;CLEAR DMA FF
         OUT       (DMAMODE),A
         AND       3
         LD        B,A
         OR        4
         OUT       (DMASMSK),A
         LD        A,B
         RLCA
         OR        80H
         LD        C,A
         OUT       (DMAFFC),A
         LD        A,L
         OUT       (C),A
         LD        A,H
         OUT       (C),A
         INC       C
         LD        A,E
         OUT       (C),A
         LD        A,D
         OUT       (C),A
         LD        A,B
         OUT       (DMASMSK),A
         LD        A,00
         OUT       (DMACMD),A
         RET
;
;*
;
;        'S'E'E'K
;                  ENTER H = TRACK
;                  EXIT       A = 0 NO ERROR
;                               = 90H CRC ERROR
;                               = 91H SEEK ERROR
;                               = 92H SEEK TIMEOUT
SEEK     
         LD        A,H
         CPL
         OUT       (FDDATA),A ;LOAD DESIRED TRACK
         LD        B,A
         IN        A,(FDTRACK)  ;READ CURRENT TRACK
         CP        B
         JR        Z,SEEK2     ;COMPARE TO CURRENT TRACK
         LD        A,0E7H     ;IF AT TRACK
         JR        SEEK4
SEEK2    LD        A,0E3H     ;SEEK VERIFY
SEEK4    OUT       (FDCMD),A  ;SEND COMMAND
         LD        E,0
         LD        HL,0FFFFH
         EI
SEEK6    LD        A,E        ;CHECK IF SEEK DONE
         CP        01
         JR        Z,SEEK8
         DEC       HL
         LD        A,H
         OR        L
         JP        Z,SEEK50   ;SEEK TIMEOUT
         CALL      DWAIT
         JR        SEEK6
SEEK8    DI
SEEK10   IN        A,(FDSTATUS)
         BIT       0,A
         JR        Z,SEEK10     ;DISK IS BUSY
         BIT       3,A
         JR        Z,SEEK51
         BIT       4,A
         JR        Z,SEEK52
         CALL      SCTC
         XOR       A
         RET
;
SEEK50   LD        A,92H      ;SEEK TIMEOUT
         JR        SEEK80
SEEK51   LD        A,90H      ;CRC ERROR
         JR        SEEK80
SEEK52   LD        A,91H
SEEK80   PUSH      AF         ;SAVE ERROR CODE
         CALL      SCTC
         POP       AF
         AND       A     ;SET FLAGS
         RET
;
;
;
;
;
;
         ORG       0FFFH
CHECKSUM DB        0C6H
         END
